﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Patients.aspx.cs" Inherits="Patients" MasterPageFile ="~/Registry.master" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href ="styles/StyleSheet.css"/>
     <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        }
    </style>
       
</asp:Content> 
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <script type="text/javascript">
        function PopUpMessage(objMsg) {
            if (confirm(objMsg)) {
                document.getElementById('<%= HiddenFieldEfrPatients.ClientID %>').value = "false";
                document.getElementById('<%= ButtonSearchPatient.ClientID %>').click();
                return true;
            }
            else {
                return false;
            }
        } 
        </script>
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <asp:ValidationSummary ID="ValidationSummaryPatients" runat="server"  
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="True" />
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="Patients > Patient Lookup" />
    </div>    
     <asp:Panel ID="PanelObjectContent" runat="server">
        <br />
        <asp:Panel ID="PanelSelectPatient" runat="server" GroupingText="&nbsp;&nbsp;Lookup Patient&nbsp;&nbsp;" Width="100%">
            <br />
            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSSNSearch" runat="server" 
                AssociatedControlID="TextBoxPatientSSNSearch">SSN:
            </asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientSSNSearch" runat="server" 
                TabIndex="2" 
                Width = "350px">
            </asp:TextBox>
            <asp:RegularExpressionValidator ID="SSNValidator" runat="server" 
                TabIndex="3" 
                ControlToValidate="TextBoxPatientSSNSearch" 
                Display="Dynamic" 
                ErrorMessage="* Invalid SSN"
                SetFocusOnError="true" 
                ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$">
            </asp:RegularExpressionValidator>         
            <br /><br />
            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxPatientFirstNameSearch" runat="server" AssociatedControlID="TextBoxPatientFirstNameSearch">First Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientFirstNameSearch" runat="server" Width = "350px"></asp:TextBox>
            <br /><br />
            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxPatientLastNameSearch" runat="server" AssociatedControlID="TextBoxPatientLastNameSearch">Last Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientLastNameSearch" runat="server" Width = "350px"></asp:TextBox>
            <br /><br />
            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxPatientICNSearch" runat="server" AssociatedControlID="TextBoxPatientICNSearch">ICN:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientICNSearch" runat="server" Width = "350px"></asp:TextBox>
            <br />
            <br />
            <asp:Button ID="ButtonSearchPatient" runat="server" Text="&nbsp;&nbsp;Search&nbsp;&nbsp;" 
                onclick="ButtonSearchPatient_Click" />
            <br /><br />
            <asp:GridView ID="GridViewEFRPatients" runat="server" Visible="False"
            DataKeyNames="PATIENT_ID"
            AutoGenerateColumns="False" Width="100%"
            AllowPaging="True" AllowSorting="True" DataSourceID = "ObjectDataSourcePatientsSearch" OnRowCommand = "Patients_RowCommand" >
            <EmptyDataTemplate>
                No EFR patients found matching your search criteria
            </EmptyDataTemplate> 
            <Columns>
                <asp:BoundField DataField="Snum" HeaderText="SSN" 
                    SortExpression="Snum" >
                    <ItemStyle HorizontalAlign="Left" />
                </asp:BoundField>

                <asp:BoundField DataField="FullName" HeaderText="Full Name" 
                    SortExpression="LAST_NAME" >
                    <ItemStyle HorizontalAlign="Left" />
                </asp:BoundField>

                <asp:TemplateField 
                    HeaderText="Site Number" 
                    SortExpression = "STD_INSTITUTION.STATIONNUMBER">
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" 
                            Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.STATIONNUMBER")), false) %>'>
                        </asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                 <asp:TemplateField 
                    HeaderText="Facility" 
                    SortExpression = "STD_INSTITUTION.VISTANAME">
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" 
                            Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.VISTANAME")), false) %>'>
                        </asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="City" SortExpression="CITY">
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelCity" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CITY")), false)%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:ButtonField 
                    HeaderText="Patient Information" 
                    ButtonType = "Button" 
                    Text = "Patient Information" 
                    CommandName = "Details" 
                    AccessibleHeaderText = "Select" 
                    ControlStyle-Width="130px" 
                    ItemStyle-Width = "130px"/>
                
                <asp:ButtonField 
                    HeaderText="Workflows" 
                    ButtonType = "Button" 
                    Text = "Workflows" 
                    CommandName = "Workflows" 
                    AccessibleHeaderText = "Workflows" 
                    ControlStyle-Width="80px" 
                    ItemStyle-Width = "80px" />
            
                <asp:TemplateField HeaderText="Related Diagnoses" ControlStyle-Width="130px" ItemStyle-Width = "130px">
                    <ItemTemplate>
                        <asp:Button 
                            ID = "buttonDiagnostics"  
                            runat = "server" 
                            UseSubmitBehavior="false" 
                            Text = "Related Diagnoses" 
                            CommandArgument = '<%# Container.DataItemIndex %>' 
                            CommandName = "Diagnostics" 
                            Enabled = '<%# (int)Eval("DiagnosticsCount") > 0  %>' />   
                    </ItemTemplate>
                </asp:TemplateField> 
 
                 <asp:TemplateField HeaderText="Lab Tests" ControlStyle-Width="80px" ItemStyle-Width = "80px">
                    <ItemTemplate>
                        <asp:Button 
                            ID = "buttonLabTests"  
                            runat = "server" 
                            UseSubmitBehavior="false" 
                            Text = "Lab Tests"  
                            CommandName = "LabTests" 
                            CommandArgument = '<%# Container.DataItemIndex %>' 
                            Enabled = '<%# (int)Eval("RELATED_LAB_TESTs.Count") > 0  %>' />   
                    </ItemTemplate>
                </asp:TemplateField> 

                <asp:ButtonField 
                    HeaderText="Images" 
                    ButtonType = "Button" 
                    Text = "Images" 
                    CommandName = "Images" 
                    AccessibleHeaderText = "Images" 
                    ControlStyle-Width="80px" 
                    ItemStyle-Width = "80px" />

           </Columns>
            </asp:GridView>
             <asp:GridView ID="GridViewNonEfrPatients" runat="server" Visible="False"
            DataKeyNames="PATIENT_ID"
            AutoGenerateColumns="False" Width="100%"
            AllowPaging="True" AllowSorting="True" DataSourceID = "ObjectDataSourceNonEfrPatientsSearch" OnRowCommand = "NonEfrPatients_RowCommand" >
            <EmptyDataTemplate>
                This patient does not exist in either the EFR or Registries database.  Please contact the system administrator.
            </EmptyDataTemplate> 
            <Columns>
                <asp:BoundField DataField="Snum" HeaderText="SSN" 
                    SortExpression="Snum" >
                    <ItemStyle HorizontalAlign="Left" />
                </asp:BoundField>
                <asp:BoundField DataField="FullName" HeaderText="Full Name" 
                    SortExpression="LAST_NAME" >
                    <ItemStyle HorizontalAlign="Left" />
                </asp:BoundField>
                <asp:TemplateField 
                    HeaderText="Site Number" 
                    SortExpression = "STD_INSTITUTION.STATIONNUMBER">
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" 
                            Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.STATIONNUMBER")), false) %>'>
                        </asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField 
                    HeaderText="Facility" 
                    SortExpression = "STD_INSTITUTION.VISTANAME">
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" 
                            Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.VISTANAME")), false) %>'>
                        </asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="City" SortExpression="CITY">
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelCity" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CITY")), false)%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:ButtonField ButtonType = "Button" Text = "Create Referral" CommandName = "AddReferral" AccessibleHeaderText = "Select" ControlStyle-Width="120px" ItemStyle-Width = "120px"/>
            
            </Columns>
            </asp:GridView>
           <br />
            <asp:ObjectDataSource ID="ObjectDataSourcePatientsSearch" runat="server" 
                SelectMethod="SelectBySearchCriteria" 
                SelectCountMethod="SelectBySearchCriteriaCount" 
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"   
                TypeName="VeteransAffairs.Registries.BusinessManager.EFRPatientManager">               
                <SelectParameters>
                    <asp:ControlParameter ControlID="TextBoxPatientFirstNameSearch" 
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringFirstName" Type="String"/>
                    
                    <asp:ControlParameter ControlID="TextBoxPatientLastNameSearch"
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringLastName" Type="String"/>
                         
                    <asp:ControlParameter ControlID="TextBoxPatientSSNSearch"
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringSSN" Type="String"/>
                         
                     <asp:ControlParameter ControlID="TextBoxPatientICNSearch"
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringICN" Type="String"/>
                    
                    <asp:Parameter Name="sort" Type="String" />
                    <asp:Parameter Name="startRow" Type="Int32" />
                    <asp:Parameter Name="maxRows" Type="Int32" />

                    <asp:Parameter Name="efrPatients" Type="Boolean" DefaultValue="true" />

             </SelectParameters>
            </asp:ObjectDataSource>
             <asp:ObjectDataSource ID="ObjectDataSourceNonEfrPatientsSearch" runat="server" 
                SelectMethod="SelectBySearchCriteria" 
                SelectCountMethod="SelectBySearchCriteriaCount" 
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"   
                TypeName="VeteransAffairs.Registries.BusinessManager.EFRPatientManager">               
                <SelectParameters>
                    <asp:ControlParameter ControlID="TextBoxPatientFirstNameSearch" 
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringFirstName" Type="String"/>
                    
                    <asp:ControlParameter ControlID="TextBoxPatientLastNameSearch"
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringLastName" Type="String"/>
                         
                    <asp:ControlParameter ControlID="TextBoxPatientSSNSearch"
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringSSN" Type="String"/>
                         
                     <asp:ControlParameter ControlID="TextBoxPatientICNSearch"
                         ConvertEmptyStringToNull = "true"  Direction="Input" Name="searchStringICN" Type="String"/>
                    
                    <asp:Parameter Name="sort" Type="String" />
                    <asp:Parameter Name="startRow" Type="Int32" />
                    <asp:Parameter Name="maxRows" Type="Int32" />

                    <asp:Parameter Name="efrPatients" Type="Boolean" DefaultValue="false" />
             </SelectParameters>
            </asp:ObjectDataSource>
           
        </asp:Panel>
    </asp:Panel> 
    <asp:HiddenField runat="server" ID="HiddenFieldEfrPatients" Value="true" />
</asp:Content> 